@extends('layouts.adminmaster')

							@section('content')

							<!--Page header-->
							<div class="page-header d-xl-flex d-block">
								<div class="page-leftheader">
									<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">Social Login</span></h4>
								</div>
							</div>
							<!--End Page header-->
							
							<!--Social Login-->
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<form method="POST" action="{{ route('settings.sociallogin.update') }}" enctype="multipart/form-data">
									@csrf

									@honeypot
										<div class="row">
											<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
												<div class="card">
													<div class="card-header d-sm-max-flex pt-2">
														<h3 class="card-title"> Envato </h3>
														<div class="card-options">
															<div class="switch_section  m-0">
																<div class="switch-toggle float-end d-flex">
																	<a class="onoffswitch2">
																		<input type="checkbox" id="myonoffswitch18789" name="envato_status" class=" toggle-class onoffswitch2-checkbox" @if($credentials->envato_status == 'enable') checked @endif>
																		<label for="myonoffswitch18789" class="toggle-class onoffswitch2-label"></label>
																	</a>
																</div>
															</div>
														</div>
													</div>
													<div class="card-body pt-5">
														<div class="col-sm-12 col-md-12 ">
															<div class="form-group ">
																<label class="form-label">Envato App ID</label>
																<input type="text" name="envato_client_id" id="envato_client_id" class="form-control  @error('envato_client_id') is-invalid @enderror" value="{{ $credentials->envato_client_id }}">
																@error('envato_client_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror

															</div>
														</div>
														<div class="col-sm-12 col-md-12">
															<div class="form-group ">
																<label class="form-label">Envato Secret</label>
																<input type="password" name="envato_secret_id" id="envato_secret_id" class="form-control  @error('envato_secret_id') is-invalid @enderror" value="{{ $credentials->envato_secret_id }}" autocomplete="new-password">
																@error('envato_secret_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror

															</div>
														</div>
														<div class="col-md-12">
															<div class="form-group">
																<label>Callback/Redirect URL</label>
																<p class="text-bold p-2 bg-light br-7 mb-1">{{ route('social.login-callback', 'envato') }}</p>
																<small class="text-muted"><i>{{trans('langconvert.admindashboard.envatologinconrent')}}</i></small>
															</div>
														</div>
													</div>
													<div class="card-footer">
														<div class="form-group float-end mb-0">
															<input type="submit" class="btn btn-secondary" value="{{trans('langconvert.admindashboard.savechanges')}}" onclick="this.disabled=true;this.form.submit();">
														</div>
													</div>	
												</div>
											</div>
											<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
												<div class="card">
													<div class="card-header pt-2 d-sm-max-flex ">
														<h3 class="card-title"> Google </h3>
														<div class="card-options"> 
															<div class="switch_section m-0">
																<div class="switch-toggle float-end d-flex">
																	<a class="onoffswitch2">
																		<input type="checkbox" id="myonoffswitch18" name="google_status" class=" toggle-class onoffswitch2-checkbox" @if($credentials->google_status == 'enable') checked @endif>
																		<label for="myonoffswitch18" class="toggle-class onoffswitch2-label"></label>
																	</a>
																</div>
															</div>
														</div>
													</div>
													<div class="card-body pt-5">
														<div class="col-sm-12 col-md-12 ">
															<div class="form-group ">
																<label class="form-label">Google App ID</label>
																<input type="text" name="google_client_id" id="google_client_id" class="form-control  @error('google_client_id') is-invalid @enderror" value="{{ $credentials->google_client_id }}">
																@error('google_client_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror

															</div>
														</div>
														<div class="col-sm-12 col-md-12">
															<div class="form-group ">
																<label class="form-label">Google Secret</label>
																<input type="password" name="google_secret_id" id="google_secret_id" class="form-control  @error('facebook_client_id') is-invalid @enderror" value="{{ $credentials->google_secret_id }}" autocomplete="new-password">
																@error('google_secret_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror

															</div>
														</div>
														<div class="col-md-12">
															<div class="form-group">
																<label>Callback/Redirect URL</label>
																<p class="text-bold p-2 bg-light br-7 mb-1">{{ route('social.login-callback', 'google') }}</p>
																<small class="text-muted"><i>{{trans('langconvert.admindashboard.googleloginconrent')}}</i></small>
															</div>
														</div>
													</div>
													<div class="card-footer">
														<div class="form-group float-end mb-0">
															<input type="submit" class="btn btn-secondary" value="{{trans('langconvert.admindashboard.savechanges')}}" onclick="this.disabled=true;this.form.submit();">
														</div>
													</div>	
												</div>
											</div>
											<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
												<div class="card">
													<div class="card-header pt-2 d-sm-max-flex">
														<h3 class="card-title">Facebook</h3>
														<div class="card-options">
															<div class="switch_section m-0">
																<div class="switch-toggle d-flex float-end">
																	<a class="onoffswitch2">
																		<input type="checkbox" id="myonoffswitch19" name="facebook_status"  class=" toggle-class onoffswitch2-checkbox"  @if($credentials->facebook_status == 'enable') checked @endif>
																		<label for="myonoffswitch19" class="toggle-class onoffswitch2-label" ></label>
																	</a>
																</div>
															</div>
														</div>
													</div>
													<div class="card-body pt-5">
														<div class="col-sm-12 col-md-12 ">
															<div class="form-group ">
																<label class="form-label">Facebook App ID</label>
																<input type="text" name="facebook_client_id" id="facebook_client_id" class="form-control @error('facebook_client_id') is-invalid @enderror" value="{{ $credentials->facebook_client_id }}">
																@error('facebook_client_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror

															</div>
														</div>
														<div class="col-sm-12 col-md-12">
															<div class="form-group ">
																<label class="form-label">Facebook Secret</label>
																<input type="password" name="facebook_secret_id" id="facebook_secret_id" class="form-control @error('facebook_secret_id') is-invalid @enderror" value="{{ $credentials->facebook_secret_id }}" autocomplete="new-password">
																@error('facebook_secret_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror

															</div>
														</div>
														<div class="col-md-12">
															<div class="form-group">
																<label>Callback/Redirect URL</label>
																<p class="text-bold p-2 bg-light br-7 mb-1">{{ route('social.login-callback', 'facebook') }}</p>
																<small class="text-muted"><i>{{trans('langconvert.admindashboard.facebookloginconrent')}}</i></small>
															</div>
														</div>
													</div>
													<div class="card-footer">
														<div class="form-group float-end mb-0">
															<input type="submit" class="btn btn-secondary" value="{{trans('langconvert.admindashboard.savechanges')}}" onclick="this.disabled=true;this.form.submit();">
														</div>
													</div>
												</div>
											</div>
											<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
												<div class="card">
													<div class="card-header pt-2 d-sm-max-flex">
														<h3 class="card-title">Twitter</h3>
														<div class="card-options">
															<div class="switch_section m-0">
																<div class="switch-toggle d-flex float-end">
																	<a class="onoffswitch2">
																		<input type="checkbox" id="myonoffswitch20" name="twitter_status"  class=" toggle-class onoffswitch2-checkbox"  @if($credentials->twitter_status == 'enable') checked @endif>
																		<label for="myonoffswitch20" class="toggle-class onoffswitch2-label" ></label>
																	</a>
																</div>
															</div>
														</div>
													</div>
													<div class="card-body pt-5">
														<div class="col-sm-12 col-md-12 ">
															<div class="form-group ">
																<label class="form-label">Twitter App ID</label>
																<input type="text" name="twitter_client_id" id="twitter_client_id" class="form-control @error('twitter_client_id') is-invalid @enderror" value="{{ $credentials->twitter_client_id }}">
																@error('twitter_client_id')

																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror
																
															</div>
														</div>
														<div class="col-sm-12 col-md-12">
															<div class="form-group ">
																<label class="form-label">Twitter Secret</label>
																<input type="password" name="twitter_secret_id" id="twitter_secret_id" class="form-control @error('twitter_secret_id') is-invalid @enderror" value="{{ $credentials->twitter_secret_id }}" autocomplete="new-password">
																@error('twitter_secret_id')
																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror
															</div>
														</div>
														<div class="col-md-12">
															<div class="form-group">
																<label>Callback/Redirect URL</label>
																<p class="text-bold p-2 bg-light br-7 mb-1">{{ route('social.login-callback', 'twitter') }}</p>
																<small class="text-muted"><i>{{trans('langconvert.admindashboard.twitterloginconrent')}}</i></small>
															</div>
														</div>
													</div>
													<div class="card-footer">
														<div class="form-group float-end mb-0">
															<input type="submit" class="btn btn-secondary" value="{{trans('langconvert.admindashboard.savechanges')}}" onclick="this.disabled=true;this.form.submit();">
														</div>
													</div>
												</div>
											</div>
										</div>
								</form>
							</div>
							<!--End Social Login-->

							@endsection


