
@extends('layouts.adminmaster')

		@section('styles')

		<!-- INTERNAl Summernote css -->
		<link rel="stylesheet" href="{{asset('assets/plugins/summernote/summernote.css')}}">

		<!-- INTERNAl Dropzone css -->
		<link href="{{asset('assets/plugins/dropzone/dropzone.css')}}" rel="stylesheet" />

		@endsection

							@section('content')

							<!--Page header-->
							<div class="page-header d-xl-flex d-block">
								<div class="page-leftheader">
									<h4 class="page-title"><span class="font-weight-normal text-muted ms-2">{{trans('langconvert.adminmenu.createticket')}}</span></h4>
								</div>
							</div>
							<!--End Page header-->

							<!-- Create Ticket List-->
							<div class="col-xl-12 col-lg-12 col-md-12">
								<div class="card ">
									<div class="card-header border-0">
										<h4 class="card-title">{{trans('langconvert.admindashboard.newticket')}}</h4>
									</div>
									<form action="{{url('/admin/createticket')}}" method="post" id="formdata" enctype="multipart/form-data">
										@csrf

										@honeypot

										<div class="card-body">
											<div class="form-group ">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.ticketsubject')}} <span class="text-red">*</span></label>
													</div>
													<div class="col-md-9">
														<input type="text" id="subject" class="form-control @error('subject') is-invalid @enderror" placeholder="Subject" name="subject" value="{{ old('subject') }}">
														@error('subject')
														
															<span class="invalid-feedback" role="alert">
																<strong>{{ $message }}</strong>
															</span>
														@enderror

													</div>
												</div>
											</div>
											<div class="form-group">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.emailaddress')}} <span class="text-red">*</span></label>
													</div>
													<div class="col-md-9">
														<input type="text" class="form-control @error('email') is-invalid @enderror" placeholder="Email" value="{{ old('email') }}" name="email">
														@error('email')

															<span class="invalid-feedback" role="alert">
																<strong>{{ $message }}</strong>
															</span>
														@enderror

													</div>
												</div>
											</div>
											<div class="form-group">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.priority')}} </label>
													</div>
													<div class="col-md-9">
														<select  class="form-control form-select select2 @error('priority') is-invalid @enderror"  data-placeholder="Select Priority" name="priority">
															<option label="Select Priority"></option>
															<option value="Critical" @if(old('priority') == 'Critical') selected @endif>Critical</option>
															<option value="High" @if(old('priority') == 'High') selected @endif>High</option>
															<option value="Medium" @if(old('priority') == 'Medium') selected @endif>Medium</option>
															<option value="Low" @if(old('priority') == 'Low') selected @endif>Low</option>
														</select>
														@error('priority')

															<span class="invalid-feedback" role="alert">
																<strong>{{ $message }}</strong>
															</span>
														@enderror

													</div>
												</div>
											</div>
											<div class="form-group">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.ticketcategory')}}<span class="text-red">*</span></label>
													</div>
													<div class="col-md-9">
														<select  class="form-control select2-show-search  select2 @error('category') is-invalid @enderror"  data-placeholder="Select Category" name="category" id="category">
															<option label="Select Category"></option>
															@foreach ($categories as $category)

																<option value="{{ $category->id }}" @if(old('category') == $category->id) selected @endif>{{ $category->name }}</option>
															@endforeach

														</select>
														@error('category')

															<span class="invalid-feedback" role="alert">
																<strong>{{ $message }}</strong>
															</span>
														@enderror

													</div>
												</div>
											</div>
											<div class="form-group" id="selectSubCategory">
											</div>
											<div class="form-group" id="envatopurchase">
											</div>
											<div class="form-group ticket-summernote ">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.ticketdescription')}}<span class="text-red">*</span></label>
													</div>
													<div class="col-md-9">
														<textarea class="summernote @error('message') is-invalid @enderror" name="message">{{old('message')}}</textarea>
	
														@error('message')

															<span class="invalid-feedback" role="alert">
																<strong>{{ $message }}</strong>
															</span>
														@enderror

													</div>
												</div>
											</div>
											<div class="form-group">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.uploadimage')}}</label>
													</div>
													<div class="col-md-9">
														<div class="form-group mb-0">
															<div class="needsclick dropzone" id="document-dropzone"></div>
														</div>
														<small class="text-muted"><i>{{trans('langconvert.admindashboard.filesizenotbe')}} {{setting('FILE_UPLOAD_MAX')}}{{trans('langconvert.admindashboard.mb')}}</i></small>
													</div>
												</div>
											</div>
										</div>
										<div class="card-footer">
											<div class="form-group float-end">
												<input type="submit"  class="btn btn-secondary btn-lg purchasecode"  value="{{trans('langconvert.adminmenu.createticket')}}" onclick="this.disabled=true;this.form.submit();">
											</div>
										</div>
									</form>
								</div>
							</div>
							<!--End Create Ticket List-->
							@endsection

		@section('scripts')

		<!-- INTERNAL Vertical-scroll js-->
		<script src="{{asset('assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}"></script>

		<!-- INTERNAL Summernote js  -->
		<script src="{{asset('assets/plugins/summernote/summernote.js')}}"></script>

		<!-- INTERNAL Index js-->
		<script src="{{asset('assets/js/support/support-sidemenu.js')}}"></script>
		<script src="{{asset('assets/js/support/support-createticket.js')}}"></script>
		<script src="{{asset('assets/js/select2.js')}}"></script>

		<!-- INTERNAL Dropzone js-->
		<script src="{{asset('assets/plugins/dropzone/dropzone.js')}}"></script>

		<script type="text/javascript">

			"use strict";

			// Image Upload
			var uploadedDocumentMap = {}
			Dropzone.options.documentDropzone = {
			  url: '{{route('imageuploadadmin')}}',
			  maxFilesize: '{{setting('FILE_UPLOAD_MAX')}}', // MB
			  addRemoveLinks: true,
			  acceptedFiles: '{{setting('FILE_UPLOAD_TYPES')}}',
				headers: {
					'X-CSRF-TOKEN': "{{ csrf_token() }}"
				},
			  success: function (file, response) {
				$('form').append('<input type="hidden" name="ticket[]" value="' + response.name + '">')
				uploadedDocumentMap[file.name] = response.name
			  },
			  removedfile: function (file) {
				file.previewElement.remove()
				var name = ''
				if (typeof file.file_name !== 'undefined') {
				  name = file.file_name
				} 
				else {
				  name = uploadedDocumentMap[file.name]
				}
				$('form').find('input[name="ticket[]"][value="' + name + '"]').remove()
			  },
			  init: function () {
				@if(isset($project) && $project->document)
				  var files =
					{!! json_encode($project->document) !!}
				  for (var i in files) {
					var file = files[i]
					this.options.addedfile.call(this, file)
					file.previewElement.classList.add('dz-complete')
					$('form').append('<input type="hidden" name="ticket[]" value="' + file.file_name + '">')
				  }
				@endif

				this.on('error', function(file, errorMessage) {
					if (errorMessage.message) {
					
						var errorDisplay = document.querySelectorAll('[data-dz-errormessage]');
						errorDisplay[errorDisplay.length - 1].innerHTML = errorMessage.message;
					}
				});
			  }
			}
				
			// Csrf field
			$.ajaxSetup({
				headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}
			});

			//Category change
			$('#category').on('change',function(e) {
				var cat_id = e.target.value;
				$.ajax({
					url:"{{ route('admin.subcat') }}",
					type:"POST",
						data: {
						cat_id: cat_id
						},
					success:function (data) {
						if(data.subcategories.length >= 1){
							
							$('#subcategory')?.empty();
							$('#selectSubCategory .row')?.remove();
							let selectDiv = document.querySelector('#selectSubCategory');
							let Divrow = document.createElement('div');
							Divrow.setAttribute('class','row mt-4');
							let Divcol3 = document.createElement('div');
							Divcol3.setAttribute('class','col-md-3');
							let selectlabel =  document.createElement('label');
							selectlabel.setAttribute('class','form-label mb-0 mt-2')
							selectlabel.innerText = "Projects";
							let divcol9 = document.createElement('div');
							divcol9.setAttribute('class', 'col-md-9');
							let selecthSelectTag =  document.createElement('select');
							selecthSelectTag.setAttribute('class','form-control select2-show-search');
							selecthSelectTag.setAttribute('id', 'subcategory');
							selecthSelectTag.setAttribute('name', 'project');
							selecthSelectTag.setAttribute('data-placeholder','Select Projects');
							let selectoption = document.createElement('option');
							selectoption.setAttribute('label','Select Projects')
							selectDiv.append(Divrow);
							Divrow.append(Divcol3);
							Divcol3.append(selectlabel);
							divcol9.append(selecthSelectTag);
							selecthSelectTag.append(selectoption);
							Divrow.append(divcol9);
							
							$('.select2-show-search').select2();
							$.each(data.subcategories,function(index,subcategory){
							$('#subcategory').append('<option value="'+subcategory.name+'">'+subcategory.name+'</option>');
							})
						}
						else{
							$('#subcategory')?.empty();
							$('#selectSubCategory .row')?.remove();
						}
					}
				})
			});


			// When category change its gets a input field with envato purchase verfication
			$('#category').on('change', function(e){
				var cats_id = e.target.value;
				$.ajax({
					url:"{{ route('guest.catenvato') }}",
					type:"POST",
					data: {
						cats_id: cats_id
					},
					success:function (data) {
						if(data.envatosuccess.length >= 1){
							$('#envato_id')?.empty();
							$('#envatopurchase .row')?.remove();
							let selectDiv = document.querySelector('#envatopurchase');
							let Divrow = document.createElement('div');
							Divrow.setAttribute('class','row mt-4');
							let Divcol3 = document.createElement('div');
							Divcol3.setAttribute('class','col-md-3');
							let selectlabel =  document.createElement('label');
							selectlabel.setAttribute('class','form-label mb-0 mt-2')
							selectlabel.innerHTML = "Envato Purchase Code <span class='text-red'>*</span>";
							let divcol9 = document.createElement('div');
							divcol9.setAttribute('class', 'col-md-9');
							let selecthSelectTag =  document.createElement('input');
							selecthSelectTag.setAttribute('class','form-control');
							selecthSelectTag.setAttribute('type','search');
							selecthSelectTag.setAttribute('id', 'envato_id');
							selecthSelectTag.setAttribute('name', 'envato_id');
							selecthSelectTag.setAttribute('placeholder', 'Enter Your Purchase Code');
							let selecthSelectInput =  document.createElement('input');
							selecthSelectInput.setAttribute('type','hidden');
							selecthSelectInput.setAttribute('id', 'envato_support');
							selecthSelectInput.setAttribute('name', 'envato_support');
							selectDiv.append(Divrow);
							Divrow.append(Divcol3);
							Divcol3.append(selectlabel);
							divcol9.append(selecthSelectTag);
							divcol9.append(selecthSelectInput);
							Divrow.append(divcol9);
							$('.purchasecode').attr('disabled', true);
							
						}else{
							$('#envato_id')?.empty();
							$('#envatopurchase .row')?.remove();
							$('.purchasecode').removeAttr('disabled');
						}
						
					},
					error:function(data) {

					}
				});
				
			});

			// Purchase Code Validation
			$("body").on('focusout', '#envato_id', function() {
				let value = $(this).val();
				if (value != '') {
					var _token = $('input[name="_token"]').val();
					$.ajax({
						url: "{{ route('guest.envatoverify') }}",
						method: "POST",
						data: {data: value, _token: _token},

						dataType:"json",

						success: function (data) {
							if(data.valid == 'true'){
									$('.purchasecode').removeAttr('disabled');
									$('#envato_id').css('border', '1px solid #02f577');
									$('#envato_support').val('Supported');
									toastr.success(data.message);
								}
								if(data.valid == 'expried'){
									$('.purchasecode').removeAttr('disabled');
									$('#envato_id').css('border', '1px solid #02f577');
									$('#envato_support').val('Expired');
									toastr.warning(data.message);
								}
								if(data.valid == 'false'){
									$('.purchasecode').attr('disabled', true);
									$('#envato_id').css('border', '1px solid #e13a3a');
									toastr.error(data.message);
								}
							
						
						},
						error: function (data) {

						}
					});
				}else{
					toastr.error('Purchase Code field is Required');
					$('.purchasecode').attr('disabled', true);
					$('#envato_id').css('border', '1px solid #e13a3a');
				}
			});

		</script>

		@endsection
