
@extends('layouts.usermaster')

		@section('styles')

		<!-- INTERNAl Summernote css -->
		<link rel="stylesheet" href="{{asset('assets/plugins/summernote/summernote.css')}}">

		<!-- INTERNAl Dropzone css -->
		<link href="{{asset('assets/plugins/dropzone/dropzone.css')}}" rel="stylesheet" />

		@endsection

		@section('content')

		<!-- Section -->
		<section>
			<div class="bannerimg cover-image" data-bs-image-src="{{asset('assets/images/photos/banner1.jpg')}}">
				<div class="header-text mb-0">
					<div class="container">
						<div class="row text-white">
							<div class="col">
								<h1 class="mb-0">{{trans('langconvert.menu.guestticket')}}</h1>
							</div>
							<div class="col col-auto">
								<ol class="breadcrumb text-center">
									<li class="breadcrumb-item">
										<a href="{{url('/')}}" class="text-white-50">{{trans('langconvert.menu.home')}}</a>
									</li>
									<li class="breadcrumb-item active">
										<a href="#" class="text-white">{{trans('langconvert.menu.guestticket')}}</a>
									</li>
								</ol>
							</div>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!-- Section -->

		<!--Create Ticket-->
		<section>
			<div class="cover-image sptb">
				<div class="container">
					<div class="row justify-content-center">
						<div class="col-xl-9">
							<div class="card">
								<div class="card-header  border-0">
									<h4 class="card-title">{{trans('langconvert.menu.guestticket')}}</h4>
								</div>
								<form action="{{url('/guest/openticket')}}" method="post" id="formdata" enctype="multipart/form-data">
									@csrf
									@honeypot
									<div class="card-body">
										<div class="form-group ">
											<div class="row">
												<div class="col-md-3">
													<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.ticketsubject')}} <span class="text-red">*</span></label>
												</div>
												<div class="col-md-9">
													<input type="text" id="subject" class="form-control @error('subject') is-invalid @enderror" placeholder="Subject" name="subject" value="{{ old('subject') }}">
													@error('subject')
														<span class="invalid-feedback" role="alert">
															<strong>{{ $message }}</strong>
														</span>
													@enderror
												</div>
											</div>
										</div>
										<div class="form-group">
											<div class="row">
												<div class="col-md-3">
													<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.emailaddress')}} <span class="text-red">*</span></label>
												</div>
												<div class="col-md-9">
													<input type="text" class="form-control @error('email') is-invalid @enderror" placeholder="Email" name="email" >
													@error('email')
														<span class="invalid-feedback" role="alert">
															<strong>{{ $message }}</strong>
														</span>
													@enderror
												</div>
											</div>
										</div>
										@if(setting('PRIORITY_ENABLE') == 'yes')
										<div class="form-group">
											<div class="row">
												<div class="col-md-3">
													<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.priority')}}</label>
												</div>
												<div class="col-md-9">
													<select  class="form-control form-select select2 @error('priority') is-invalid @enderror"  data-placeholder="Select Priority" name="priority">
														<option label="Select Priority"></option>
														<option value="Low">Low - Please login to set priroty</option>
													</select>
													@error('priority')
														<span class="invalid-feedback" role="alert">
															<strong>{{ $message }}</strong>
														</span>
													@enderror
												</div>
											</div>
										</div>
										@endif
										<div class="form-group">
											<div class="row">
												<div class="col-md-3">
													<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.ticketcategory')}} <span class="text-red">*</span></label>
												</div>
												<div class="col-md-9">
													<select  class="form-control select2-show-search  select2 @error('category') is-invalid @enderror"  data-placeholder="Select Category" name="category" id="category">
														<option label="Select Category"></option>
														@foreach ($categories as $category)
															<option value="{{ $category->id }}">{{ $category->name }}</option>
														@endforeach
													</select>
													@error('category')
														<span class="invalid-feedback" role="alert">
															<strong>{{ $message }}</strong>
														</span>
													@enderror
												</div>
											</div>
										</div>
										<div class="form-group" id="selectSubCategory">
										</div>
										<div class="form-group" id="envatopurchase">
										</div>
										<div class="form-group ticket-summernote ">
											<div class="row">
												<div class="col-md-3">
													<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.ticketdescription')}} <span class="text-red">*</span></label>
												</div>
												<div class="col-md-9">
													<textarea class=" form-control summernote @error('message') is-invalid @enderror" name="message"></textarea>

													@error('message')
														<span class="invalid-feedback" role="alert">
															<strong>{{ $message }}</strong>
														</span>
													@enderror
												</div>
											</div>
										</div>
										@if(setting('GUEST_FILE_UPLOAD_ENABLE') == 'yes')
										<div class="form-group">
											<div class="row">
												<div class="col-md-3">
													<label class="form-label mb-0 mt-2">{{trans('langconvert.admindashboard.uploadimage')}}</label>
												</div>
												<div class="col-md-9">
													<div class="form-group mb-0">
														<div class="needsclick dropzone" id="document-dropzone"></div>
													</div>
													<small class="text-muted"><i>{{trans('langconvert.admindashboard.filesizenotbe')}} {{setting('FILE_UPLOAD_MAX')}}{{trans('langconvert.admindashboard.mb')}}</i></small>
												</div>
											</div>
										</div>
										@endif

										@if(setting('CAPTCHATYPE')=='manual')
                                            @if(setting('RECAPTCH_ENABLE_GUEST')=='yes')
											<div class="form-group mt-4">
												<div class="row">
													<div class="col-md-3">
														<label class="form-label mb-0 mt-2">{{trans('langconvert.menu.entercaptcha')}} <span class="text-red">*</span></label>
													</div>
													<div class="col-md-9">
														<div class="form-group row">
															<div class="col-md-6">
																<input type="text" id="captcha" class="form-control @error('captcha') is-invalid @enderror" placeholder="Enter Captcha" name="captcha">
																@error('captcha')
																	<span class="invalid-feedback" role="alert">
																		<strong>{{ $message }}</strong>
																	</span>
																@enderror
															</div>
															<div class="col-md-6">
																<div class="captcha">
																	<span>{!! captcha_img('') !!}</span>
																	<button type="button" class="btn btn-outline-info btn-sm captchabtn"><i class="fe fe-refresh-cw"></i></button>
																</div>
															</div>
														</div>
													</div>
												</div>
											</div>
                                            @endif
                                        @endif

										<!--- if Enable the Google ReCaptcha --->
										@if(setting('CAPTCHATYPE')=='google')
										@if(setting('RECAPTCH_ENABLE_GUEST')=='yes')
										<div class="form-group">
											<div class="row">
												<div class="col-md-3">
												</div>
												<div class="col-md-9">
													<div class="form-group mb-0 mt-4">
														<div class="g-recaptcha" data-sitekey="{{setting('GOOGLE_RECAPTCHA_KEY')}}"></div>
														@if ($errors->has('g-recaptcha-response'))
															<span class="invalid-feedback" role="alert">
																<strong>{{ $errors->first('g-recaptcha-response') }}</strong>
															</span>
														@endif
													</div>
												</div>
											</div>
										</div>
										
										@endif
										@endif
									</div>
									<div class="card-footer">
										<div class="form-group float-end">
											<input type="submit"  class="btn btn-secondary btn-lg purchasecode"  value="{{trans('langconvert.adminmenu.createticket')}}" onclick="this.disabled=true;this.form.submit();">
										</div>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!--Create Ticket-->

		@endsection

		@section('scripts')

		<!-- INTERNAL Vertical-scroll js-->
		<script src="{{asset('assets/plugins/vertical-scroll/jquery.bootstrap.newsbox.js')}}"></script>


		<!-- INTERNAL Summernote js  -->
		<script src="{{asset('assets/plugins/summernote/summernote.js')}}"></script>

		<!-- INTERNAL Index js-->
		<script src="{{asset('assets/js/support/support-sidemenu.js')}}"></script>
		<script src="{{asset('assets/js/select2.js')}}"></script>

		<!-- INTERNAL Dropzone js-->
		<script src="{{asset('assets/plugins/dropzone/dropzone.js')}}"></script>

		<script type="text/javascript">

			"use strict";

			(function($)  {

				// Ajax Setup
				$.ajaxSetup({
					headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});

				// when category change its get the project list 
				$('#category').on('change',function(e) {
					var cat_id = e.target.value;
					$.ajax({
						url:"{{ route('guest.subcat') }}",
						type:"POST",
							data: {
							cat_id: cat_id
							},
						success:function (data) {
							if(data.subcategories.length >= 1){
								
								$('#subcategory')?.empty();
								$('#selectSubCategory .row')?.remove();
								let selectDiv = document.querySelector('#selectSubCategory');
								let Divrow = document.createElement('div');
								Divrow.setAttribute('class','row mt-4');
								let Divcol3 = document.createElement('div');
								Divcol3.setAttribute('class','col-md-3');
								let selectlabel =  document.createElement('label');
								selectlabel.setAttribute('class','form-label mb-0 mt-2')
								selectlabel.innerText = "Projects";
								let divcol9 = document.createElement('div');
								divcol9.setAttribute('class', 'col-md-9');
								let selecthSelectTag =  document.createElement('select');
								selecthSelectTag.setAttribute('class','form-control select2-show-search');
								selecthSelectTag.setAttribute('id', 'subcategory');
								selecthSelectTag.setAttribute('name', 'project');
								selecthSelectTag.setAttribute('data-placeholder','Select Projects');
								let selectoption = document.createElement('option');
								selectoption.setAttribute('label','Select Projects')
								selectDiv.append(Divrow);
								Divrow.append(Divcol3);
								Divcol3.append(selectlabel);
								divcol9.append(selecthSelectTag);
								selecthSelectTag.append(selectoption);
								Divrow.append(divcol9);
								$('.select2-show-search').select2();
								$.each(data.subcategories,function(index,subcategory){
								$('#subcategory').append('<option value="'+subcategory.name+'">'+subcategory.name+'</option>');
								})
							}
							else{
								$('#subcategory')?.empty();
								$('#selectSubCategory .row')?.remove();
							}
						}
					})
				});

				// When category change its gets a input field with envato purchase verfication
				$('#category').on('change', function(e){
					var cats_id = e.target.value;
					$.ajax({
						url:"{{ route('guest.catenvato') }}",
						type:"POST",
						data: {
							cats_id: cats_id
						},
						success:function (data) {
							if(data.envatosuccess.length >= 1){
								$('#envato_id')?.empty();
								$('#envatopurchase .row')?.remove();
								let selectDiv = document.querySelector('#envatopurchase');
								let Divrow = document.createElement('div');
								Divrow.setAttribute('class','row mt-4');
								let Divcol3 = document.createElement('div');
								Divcol3.setAttribute('class','col-md-3');
								let selectlabel =  document.createElement('label');
								selectlabel.setAttribute('class','form-label mb-0 mt-2')
								selectlabel.innerHTML = "Envato Purchase Code <span class='text-red'>*</span>";
								let divcol9 = document.createElement('div');
								divcol9.setAttribute('class', 'col-md-9');
								let selecthSelectTag =  document.createElement('input');
								selecthSelectTag.setAttribute('class','form-control');
								selecthSelectTag.setAttribute('type','search');
								selecthSelectTag.setAttribute('id', 'envato_id');
								selecthSelectTag.setAttribute('name', 'envato_id');
								selecthSelectTag.setAttribute('placeholder', 'Enter Your Purchase Code');
								let selecthSelectInput =  document.createElement('input');
								selecthSelectInput.setAttribute('type','hidden');
								selecthSelectInput.setAttribute('id', 'envato_support');
								selecthSelectInput.setAttribute('name', 'envato_support');
								selectDiv.append(Divrow);
								Divrow.append(Divcol3);
								Divcol3.append(selectlabel);
								divcol9.append(selecthSelectTag);
								divcol9.append(selecthSelectInput);
								Divrow.append(divcol9);
								$('.purchasecode').attr('disabled', true);
								
							}else{
								$('#envato_id')?.empty();
								$('#envatopurchase .row')?.remove();
								$('.purchasecode').removeAttr('disabled');
							}
							
						},
						error:function(data) {

						}
					});
					
				});

				// Purchase Code Validation
				$("body").on('focusout', '#envato_id', function() {
					let value = $(this).val();
					if (value != '') {
						var _token = $('input[name="_token"]').val();
						$.ajax({
							url: "{{ route('guest.envatoverify') }}",
							method: "POST",
							data: {data: value, _token: _token},

							dataType:"json",

							success: function (data) {
								if(data.valid == 'true'){
									$('.purchasecode').removeAttr('disabled');
									$('#envato_id').css('border', '1px solid #02f577');
									$('#envato_support').val('Supported');
									toastr.success(data.message);
								}
								if(data.valid == 'expried'){
									$('.purchasecode').removeAttr('disabled');
									$('#envato_id').css('border', '1px solid #02f577');
									$('#envato_support').val('Expired');
									toastr.warning(data.message);
								}
								if(data.valid == 'false'){
									$('.purchasecode').attr('disabled', true);
									$('#envato_id').css('border', '1px solid #e13a3a');
									toastr.error(data.message);
								}
								
							
							},
							error: function (data) {

							}
						});
					}else{
						toastr.error('Purchase Code field is Required');
						$('.purchasecode').attr('disabled', true);
						$('#envato_id').css('border', '1px solid #e13a3a');
					}
				});

				// Captcha Js when refresh the its gets the new captcha
				$(".captchabtn").on('click', function(e){
					e.preventDefault();
					$.ajax({
						type:'GET',
						url:'{{route('captcha.reload')}}',
						success: function(res){
							$(".captcha span").html(res.captcha);
						}
					});
				});

				// Summernote
				$('.summernote').summernote({
					placeholder: '',
					tabsize: 1,
					height: 200,
					toolbar: [['style', ['style']], ['font', ['bold', 'underline', 'clear']], // ['font', ['bold', 'italic', 'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
					['fontname', ['fontname']], ['fontsize', ['fontsize']], ['color', ['color']], ['para', ['ul', 'ol', 'paragraph']], // ['height', ['height']],
					['table', ['table']], ['insert', ['link']], ['view', ['fullscreen']], ['help', ['help']]]
				});
			
			})(jQuery);

			@if(setting('GUEST_FILE_UPLOAD_ENABLE') == 'yes')

			// Image Upload
			var uploadedDocumentMap = {}
			Dropzone.options.documentDropzone = {
			  url: '{{route('guest.imageupload')}}',
			  maxFilesize: '{{setting('FILE_UPLOAD_MAX')}}', // MB
			  addRemoveLinks: true,
			  acceptedFiles: '{{setting('FILE_UPLOAD_TYPES')}}',
			  headers: {
				'X-CSRF-TOKEN': "{{ csrf_token() }}"
			  },
			  success: function (file, response) {
				$('form').append('<input type="hidden" name="ticket[]" value="' + response.name + '">')
				uploadedDocumentMap[file.name] = response.name
			  },
			  removedfile: function (file) {
				file.previewElement.remove()
				var name = ''
				if (typeof file.file_name !== 'undefined') {
				  name = file.file_name
				} else {
				  name = uploadedDocumentMap[file.name]
				}
				$('form').find('input[name="ticket[]"][value="' + name + '"]').remove()
			  },
			  init: function () {
				@if(isset($project) && $project->document)
				  var files =
					{!! json_encode($project->document) !!}
				  for (var i in files) {
					var file = files[i]
					this.options.addedfile.call(this, file)
					file.previewElement.classList.add('dz-complete')
					$('form').append('<input type="hidden" name="ticket[]" value="' + file.file_name + '">')
				  }
				@endif
			  }
			}
			@endif

		</script>
		
		<!--- Captcha Google js -->
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>

		@endsection
