        <!--Login Modal-->
        <div class="modal fade" id="loginmodal">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('langconvert.menu.login')}}</h5>
                        <button class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="single-page customerpage">
                            <div class="wrapper wrapper2 box-shadow-0 border-0">
                                
                                <form class="card-body pt-3" id="login_form" name="login_form" method="post">
                                    @csrf
                                    @honeypot
                                    
                                    <div class="form-group">
                                        <label class="form-label">{{trans('langconvert.admindashboard.email')}} <span class="text-red">*</span></label>
                                        <input class="form-control " placeholder="Email"
                                            type="email" value="{{old('email')}}" name="email" required="" id="username">
                                            <div id="err" style="color: red"></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">{{trans('langconvert.admindashboard.password')}} <span class="text-red">*</span></label>
                                        <input class="form-control"
                                            placeholder="password" type="password" id="password" name="password" required="">
                                            <div id="passworderr" style="color: red"></div>
                                    </div>
                                    <div class="form-group">
                                        <label class="custom-control form-checkbox">
                                            <input type="checkbox" class="custom-control-input" name="remember" id="remember" {{
                                                old('remember') ? 'checked' : '' }}>
                                            <span class="custom-control-label">{{trans('langconvert.menu.rememberme')}}</span>
                                        </label>
                                    </div>
                                    @if(setting('CAPTCHATYPE')=='manual')
                                        @if(setting('RECAPTCH_ENABLE_LOGIN')=='yes')
                                        <div class="form-group row">
                                            <div class="col-md-6">
                                                <input type="text" id="captcha" class="form-control @error('captcha') is-invalid @enderror" placeholder="Enter Captcha" name="captcha">
                                                <div id="captchaerr" style="color: red"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="captcha">
                                                    <span>{!! captcha_img('') !!}</span>
                                                    <button type="button" class="btn btn-outline-info btn-sm captchabtn"><i class="fe fe-refresh-cw"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                    @endif
                                    <!--- if Enable the Google ReCaptcha --->
                                    @if(setting('CAPTCHATYPE')=='google')
                                        @if(setting('RECAPTCH_ENABLE_LOGIN')=='yes')
                                        <div class="form-group">
                                            <div class="g-recaptcha" data-sitekey="{{setting('GOOGLE_RECAPTCHA_KEY')}}"></div>
                                            @if ($errors->has('g-recaptcha-response'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                            </span>
                                            @endif
                                        </div>
                                        @endif
                                    @endif
                                    <div class="submit">
                                        <input class="btn btn-secondary btn-block" type="button" value="Login" onclick="login()">
                                    </div>
                                    <div class="text-center mt-3">
                                       <a href="#" id="forgot1" class="text-primary pb-2">{{trans('langconvert.menu.forgotpass')}}</a>
                                        @if(setting('REGISTER_DISABLE') == 'on')
                                        <p class="text-dark mb-0">{{trans('langconvert.menu.doyoulogin')}}<a class="text-primary ms-1" href="#"
                                                data-bs-toggle="modal" id="register1"
                                                data-bs-target="#registermodal">{{trans('langconvert.menu.register')}}</a></p>
                                        @endif
                                    </div>
                                </form>
                                <div class="card-body border-top-0 pb-0 pt-0">
                                    <div class="d-flex justify-content-center">
                                        @if($socialAuthSettings->facebook_status == 'enable')
                                        <a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary"
                                            data-bs-toggle="tooltip" title="Login with Facebook"
                                            onclick="window.location.href = facebook;"
                                            data-bs-original-title="Login with Facebook"> <i class="ri-facebook-line"></i> </a>
                                        @endif
                                        @if($socialAuthSettings->google_status == 'enable')
                                        <a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary"
                                            data-bs-toggle="tooltip" title="Login with Google"
                                            onclick="window.location.href = google;" data-bs-original-title="Login with Google">
                                            <i aria-hidden="true" class="ri-google-line"></i> </a>
                                        @endif
                                        @if($socialAuthSettings->twitter_status == 'enable')
                                        <a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary"
                                            data-bs-toggle="tooltip" title="Login with Google"
                                            onclick="window.location.href = twitter;"
                                            data-bs-original-title="Login with Twitter"> <i aria-hidden="true"
                                                class="ri-twitter-line"></i> </a>
                                        @endif
                                        @if($socialAuthSettings->envato_status == 'enable')
                                         <a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary d-flex justify-content-center sprukoenvato" data-bs-toggle="tooltip"
                                            title="Login with Envato" onclick="window.location.href = envato;"
                                            data-bs-original-title="Login with Envato"> 
                                            <svg  style="enable-background:new 0 0 512 512;" version="1.1" viewBox="0 0 512 512"  xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                                                <g id="_x38_5-envato"><g><g><g><path d="M401.225,19.381c-17.059-8.406-103.613,1.196-166.01,61.218      c-98.304,98.418-95.947,228.089-95.947,228.089s-3.248,13.335-17.086-6.011c-30.305-38.727-14.438-127.817-12.651-140.23      c2.508-17.494-8.615-17.999-13.243-12.229c-109.514,152.46-10.616,277.288,54.136,316.912      c75.817,46.386,225.358,46.354,284.922-85.231C509.547,218.042,422.609,29.875,401.225,19.381L401.225,19.381z M401.225,19.381" style="fill:#91D14D;"/></g></g></g></g><g id="Layer_1"/></svg>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                              
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Login Modal  -->

        <script type="text/javascript">
            "use strict";

            var facebook = "{{ route('social.login', 'facebook') }}";
            var google = "{{ route('social.login', 'google') }}";
            var twitter = "{{ route('social.login', 'twitter') }}";
            var envato = "{{ route('social.login', 'envato') }}";
            
            // Login Js submit Js
            function login()
            {
                if($('#username').val() == "")
                {
                    $('#err').html('{{trans('langconvert.functions.enteremail')}}');
                    return false;
                }
                if($('#password').val() == "")
                {
                    $('#passworderr').html('{{trans('langconvert.functions.enterpass')}}');
                    return false;
                }
                
                var data = $("#login_form").serialize();
                    
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
         
                $.ajax({
                        type : 'POST',
                        url: '{{route('client.do_ajaxlogin')}}',
                        data : data,
                    success : function(response)
                    {
                        if(response.errors){
                            $("#err").hide().html(response.errors.email).fadeIn('slow');
                            $("#captchaerr").hide().html(response.errors.captcha).fadeIn('slow');
                        }
                        if(response == 1)
                        {
                          window.location.replace('{{route('client.dashboard')}}');
                        }
                        else if(response == 3)
                        {
                            toastr.error('{{trans('langconvert.functions.usernamepassinvalid')}}');
                            $("#err").hide().html("{{trans('langconvert.functions.usernamepassinvalid')}}").fadeIn('slow');
                        }
                        else if(response == 4)
                        {
                            toastr.error('{{trans('langconvert.functions.verifyemail')}}');
                        }
                        else if(response == 5)
                        {
                            toastr.error('{{trans('langconvert.functions.accountdisable')}}');
                        }
                    }
                });
            }

            //set button id on click to hide first modal
            $("#register1").on( "click", function() {
                $('#loginmodal').modal('hide');
                $('#login_form').trigger("reset");

            });

            //trigger next modal
            $("#register1").on( "click", function() {
                $('#registermodal').modal('show');

            });

            $("#forgot1").on( "click", function() {
                $('#loginmodal').modal('hide');
                $('#login_form').trigger("reset");

            });
            
            //trigger next modal
            $("#forgot1").on( "click", function() {
                $('#forgotmodal').modal('show');

            });

            (function($){

                // Captcha Js
				$(".captchabtn").on('click', function(e){
					e.preventDefault();
					$.ajax({
						type:'GET',
						url:'{{route('captcha.reload')}}',
						success: function(res){
							$(".captcha span").html(res.captcha);
						}
					});
				});

			})(jQuery);
            
        </script>

        <!-- Captcha Js -->
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>