        <!--Register Modal-->
        <div class="modal fade" id="registermodal">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{trans('langconvert.menu.register')}}</h5>
                        <button class="close" data-bs-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="single-page customerpage">
                            <div class="wrapper wrapper2 box-shadow-0 border-0">
                                <div class="card-body pt-3">
                                    <form  id="registerform">
                                        @csrf

                                        <div class="row">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-grouphas-feedback ">
                                                    <label class="form-label">{{trans('langconvert.admindashboard.firstname')}} <span class="text-red">*</span></label>
                                                    <input class="form-control " placeholder="Firstname" type="text"
                                                        name="firstname" required="" >
                                                        <span class="text-danger">
                                                            <strong id="firstnameerror"></strong>
                                                        </span>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="form-group has-feedback">
                                                    <label class="form-label">{{trans('langconvert.admindashboard.lastname')}} <span class="text-red">*</span></label>
                                                    <input class="form-control " placeholder="Lastname" type="text"
                                                        name="lastname"  >
                                                        <span class="text-danger">
                                                            <strong id="lastnameerror"></strong>
                                                        </span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group has-feedback">
                                            <label class="form-label" for="emailInput">{{trans('langconvert.admindashboard.email')}} <span class="text-red">*</span></label>
                                            <input class="form-control" id="emailInput" placeholder="Email" type="email"
                                                name="email">
                                            <span class="text-danger">
                                                <strong id="emailerror"></strong>
                                            </span>
                                        </div>
                                        <div class="form-group has-feedback">
                                            <label class="form-label">{{trans('langconvert.admindashboard.password')}} <span class="text-red">*</span></label>
                                            <input class="form-control" placeholder="password" type="password" name="password">
                                            <span class="text-danger">
                                                <strong id="passworderror"></strong>
                                            </span>
                                        </div>
                                        <div class="form-group has-feedback ">
                                            <label class="form-label">{{trans('langconvert.admindashboard.confirmpassword')}} <span class="text-red">*</span></label>
                                            <input class="form-control" placeholder="password" type="password"
                                                name="password_confirmation">
                                            <span class="invalid-feedback" role="alert" id="password_confirmationError">
                                                <strong></strong>
                                            </span>
                                        </div>
                                        <div class="form-group has-feedback">
                                            <label class="custom-control form-checkbox">
                                                <input type="checkbox" class="custom-control-input" 
                                                value="agreed" name="agree_terms" >
                                                <span class="custom-control-label">{{trans('langconvert.userdashboard.iagree')}} <a href="{{url('page/terms')}}"
                                                        class="text-primary">{{trans('langconvert.userdashboard.termsservices')}}</a> {{trans('langconvert.userdashboard.and')}} <a
                                                        href="{{url('page/privacy-policy')}}" class="text-primary">{{trans('langconvert.userdashboard.privacypolicy')}}</a>
                                                </span>
                                            </label>
                                            <span class="text-danger" role="alert" >
                                                <strong id="exampleError"></strong>
                                            </span>
                                        </div>
                                        
                                        
                                        @if(setting('CAPTCHATYPE')=='manual')
                                            @if(setting('RECAPTCH_ENABLE_REGISTER')=='yes')
                                            <div class="form-group row">
                                                <div class="col-md-6">
                                                    <input type="text" id="captcha" class="form-control @error('captcha') is-invalid @enderror" placeholder="Enter Captcha" name="captcha">
                                                    @error('captcha')
                                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                                    <span class="text-danger" role="alert" >
                                                        <strong id="captchaError"></strong>
                                                    </span>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="captcha">
                                                        <span>{!! captcha_img('') !!}</span>
                                                        <button type="button" class="btn btn-outline-info btn-sm captchabtn"><i class="fe fe-refresh-cw"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                        @endif

                                        <!--- if Enable the Google ReCaptcha --->
                                        @if(setting('CAPTCHATYPE')=='google')
                                        @if(setting('RECAPTCH_ENABLE_REGISTER')=='yes')
                                        <div class="form-group">
                                            <div class="g-recaptcha @error('g-recaptcha-response') is-invalid @enderror" data-sitekey="{{setting('GOOGLE_RECAPTCHA_KEY')}}"></div>
                                            <span class="text-danger" role="alert" >
                                                <strong id="googleError"></strong>
                                            </span>
                                           
                                            @if ($errors->has('g-recaptcha-response'))
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                        @endif
                                        @endif
                                        <div>
                                            <input type="button" class="btn btn-secondary btn-block" id="submitForm"
                                                value="{{trans('langconvert.menu.createnewacc')}}" />

                                        </div>
                                        <div class="text-center mt-4">
                                            <p class="text-dark mb-0">{{trans('langconvert.menu.alreadyacc')}}<a class="text-primary ms-1"
                                                    href="#" data-bs-toggle="modal" id="login"
                                                    data-bs-target="#loginmodal">{{trans('langconvert.menu.login')}}</a></p>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- End Register Modal  -->
        
        <script type="text/javascript">
            "use strict";

            //set button id on click to hide first modal
            $("#login").on( "click", function() {

                $('#registermodal').modal('hide');
                $('#registerform').trigger("reset");

            });

            //trigger next modal
            $("#login").on( "click", function() {
                    $('#loginmodal').modal('show');

            });

            (function($){
                
				$(".captchabtn").on('click', function(e){
					e.preventDefault();
					$.ajax({
						type:'GET',
						url:'{{route('captcha.reload')}}',
						success: function(res){
							$(".captcha span").html(res.captcha);
						}
					});
				});

                // End Register Js
                $('#registermodal').on('click', '#submitForm', function(){
                    var registerForm = $("#registerform");
                    var formData = registerForm.serialize();
                    $( '#firstnameerror' ).html( "" );
                    $( '#lastnameerror' ).html( "" );
                    $( '#emailerror' ).html( "" );
                    $( '#passworderror' ).html( "" );
                    $( '#exampleError' ).html( "" );
                    $( '#captchaError' ).html( "" );
                    $( '#googleError' ).html( "" );
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url:'{{url('customer/register1')}}',
                        type:'POST',
                        data:formData,
                        success:function(data) {
                            if(data.errors) {
                                if(data.errors.firstname){
                                    $( '#firstnameerror' ).html( data.errors.firstname[0] );
                                }
                                if(data.errors.lastname){
                                    $( '#lastnameerror' ).html( data.errors.lastname[0] );
                                }
                                if(data.errors.email){
                                    $( '#emailerror' ).html( data.errors.email[0] );
                                }
                                if(data.errors.password){
                                    $( '#passworderror' ).html( data.errors.password[0] );
                                }
                                if(data.errors.agree_terms){
                                    $( '#exampleError' ).html( data.errors.agree_terms[0] );
                                }
                                if(data.errors.captcha){
                                    $( '#captchaError' ).html( data.errors.captcha[0] );
                                }
                                if(data.errors.grecaptcharesponse){
                                    $( '#googleError' ).html( data.errors.grecaptcharesponse[0] );
                                }

                            }
                            if(data.success) {

                                toastr.success("{{trans('langconvert.functions.newuserregister')}}");
                                $('#registermodal').modal('hide');
                                $('#registerform').trigger("reset");
                            }
                        },
                    });
                });

			})(jQuery);
        </script>

        <!-- Captrcha Js-->
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
       