@extends('layouts.custommaster')
								@section('content')
								
								<!--Register Page-->
								<div class="p-5 pt-0">
									<h1 class="mb-2">{{trans('langconvert.menu.register')}}</h1>
									<p class="text-muted">{{trans('langconvert.menu.createnew')}}</p>
								</div>
								<form class="card-body pt-3" method="post" action="{{route('auth.register')}}">
									@csrf
									@method('post')
									@honeypot

									<div class="form-group row">
										<div class="col-sm-6 col-md-6 mb-2 mb-sm-0">
											<label class="form-label">{{trans('langconvert.admindashboard.firstname')}} <span class="text-red">*</span></label>
											<input class="form-control @error('firstname') is-invalid @enderror" placeholder="Firstname" type="text"
												name="firstname" value="{{old('firstname')}}" >
											@error('firstname')

											<span class="invalid-feedback" role="alert">
												<strong>{{ $message }}</strong>
											</span>
											@enderror

										</div>
										<div class="col-sm-6 col-md-6">
											<label class="form-label">{{trans('langconvert.admindashboard.lastname')}} <span class="text-red">*</span></label>
											<input class="form-control @error('lastname') is-invalid @enderror" placeholder="Lastname" type="text"
												name="lastname" value="{{old('lastname')}}" >
											@error('lastname')

											<span class="invalid-feedback" role="alert">
												<strong>{{ $message }}</strong>
											</span>
											@enderror

										</div>
										
									</div>
									<div class="form-group">
										<label class="form-label">{{trans('langconvert.admindashboard.email')}} <span class="text-red">*</span></label>
										<input class="form-control @error('email') is-invalid @enderror" placeholder="Email" type="email" name="email"
											value="{{old('email')}}" autocomplete="username">
										@error('email')

										<span class="invalid-feedback" role="alert">
											<strong>{{ $message }}</strong>
										</span>
										@enderror

									</div>
									<div class="form-group">
										<label class="form-label">{{trans('langconvert.admindashboard.password')}} <span class="text-red">*</span></label>
										<input class="form-control @error('password') is-invalid @enderror" placeholder="password" type="password"
											name="password" autocomplete="new-password">
										@error('password')

										<span class="invalid-feedback" role="alert">
											<strong>{{ $message }}</strong>
										</span>
										@enderror

									</div>
									<div class="form-group">
										<label class="form-label">{{trans('langconvert.admindashboard.confirmpassword')}} <span class="text-red">*</span></label>
										<input class="form-control @error('password_confirmation') is-invalid @enderror" placeholder="password"
											type="password" name="password_confirmation" autocomplete="new-password">
										@error('password_confirmation')

										<span class="invalid-feedback" role="alert">
											<strong>{{ $message }}</strong>
										</span>
										@enderror

									</div>
									<div class="form-group @error('agree_terms') is-invalid @enderror">
										<label class="custom-control form-checkbox">
											<input type="checkbox" class="custom-control-input " value="agreed" name="agree_terms">
											<span class="custom-control-label">{{trans('langconvert.userdashboard.iagree')}} <a href="{{url('page/terms')}}" class="text-primary">
													{{trans('langconvert.userdashboard.termsservices')}}</a> {{trans('langconvert.userdashboard.and')}} <a href="{{url('page/privacy-policy')}}" class="text-primary">
													{{trans('langconvert.userdashboard.privacypolicy')}}</a></span>
										</label>
									</div>
									@error('agree_terms')

									<span class="invalid-feedback" role="alert">
										<strong>{{ $message }}</strong>
									</span>
									@enderror


									@if(setting('CAPTCHATYPE')=='manual')
										@if(setting('RECAPTCH_ENABLE_REGISTER')=='yes')

										<div class="form-group row @error('captcha') is-invalid @enderror">
											<div class="col-md-6">
												<input type="text" id="captcha" class="form-control " placeholder="Enter Captcha" name="captcha">
												
											</div>
											<div class="col-md-6">
												<div class="captcha">
													<span>{!! captcha_img('') !!}</span>
													<button type="button" class="btn btn-outline-info btn-sm captchabtn"><i class="fe fe-refresh-cw"></i></button>
												</div>
											</div>
										</div>
										@error('captcha')

											<span class="invalid-feedback" role="alert">
												<strong>{{ $message }}</strong>
											</span>
										@enderror
										@endif
									@endif
									
									<!--- if Enable the Google ReCaptcha --->
									@if(setting('CAPTCHATYPE')=='google')
									@if(setting('RECAPTCH_ENABLE_REGISTER')=='yes')

									<div class="form-group">
										<div class="g-recaptcha" data-sitekey="{{setting('GOOGLE_RECAPTCHA_KEY')}}"></div>
										@if ($errors->has('g-recaptcha-response'))

										<span class="invalid-feedback" role="alert">
											<strong>{{ $errors->first('g-recaptcha-response') }}</strong>
										</span>
										@endif

									</div>
									@endif
									@endif

									<div class="submit">
										<input type="submit" class="btn btn-secondary btn-block" value="{{trans('langconvert.menu.createnewacc')}}"
											onclick="this.disabled=true;this.form.submit();" />

									</div>
									<div class="text-center mt-4">
										<p class="text-dark mb-0">{{trans('langconvert.menu.alreadyacc')}}<a class="text-primary ms-1"
												href="{{url('customer/login')}}">{{trans('langconvert.menu.login')}}</a></p>
										<p class="text-dark mb-0"><a class="text-primary ms-1" href="{{url('/')}}">{{trans('langconvert.menu.meback')}}</a></p>

									</div>
								</form>
								<!--Register Page-->
								<div class="card-body border-top-0 pb-0 pt-0">
									<div class="d-flex justify-content-center">
										@if($socialAuthSettings->facebook_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary" data-bs-toggle="tooltip"
											title="Login with Facebook" onclick="window.location.href = facebook;"
											data-bs-original-title="Login with Facebook"> <i class="ri-facebook-line"></i> </a>
										@endif
										@if($socialAuthSettings->google_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary" data-bs-toggle="tooltip"
											title="Login with Google" onclick="window.location.href = google;"
											data-bs-original-title="Login with Google"> <i aria-hidden="true" class="ri-google-line"></i> </a>
										@endif
										@if($socialAuthSettings->twitter_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary" data-bs-toggle="tooltip"
											title="Login with Google" onclick="window.location.href = twitter;"
											data-bs-original-title="Login with Twitter"> <i aria-hidden="true" class="ri-twitter-line"></i> </a>
										@endif
										@if($socialAuthSettings->envato_status == 'enable')
										<a href="javascript:;" class="avatar brround me-3 mb-6 bg-primary-transparent text-primary d-flex justify-content-center sprukoenvato" data-bs-toggle="tooltip"
											title="Login with Envato" onclick="window.location.href = envato;"
											data-bs-original-title="Login with Envato"> 
											<svg  style="enable-background:new 0 0 512 512;" version="1.1" viewBox="0 0 512 512"  xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
												<g id="_x38_5-envato"><g><g><g><path d="M401.225,19.381c-17.059-8.406-103.613,1.196-166.01,61.218      c-98.304,98.418-95.947,228.089-95.947,228.089s-3.248,13.335-17.086-6.011c-30.305-38.727-14.438-127.817-12.651-140.23      c2.508-17.494-8.615-17.999-13.243-12.229c-109.514,152.46-10.616,277.288,54.136,316.912      c75.817,46.386,225.358,46.354,284.922-85.231C509.547,218.042,422.609,29.875,401.225,19.381L401.225,19.381z M401.225,19.381" style="fill:#91D14D;"/></g></g></g></g><g id="Layer_1"/></svg>
											</a>
										@endif
									</div>
								</div>
								<script>
									var facebook = "{{ route('social.login', 'facebook') }}";
									var google = "{{ route('social.login', 'google') }}";
									var twitter = "{{ route('social.login', 'twitter') }}";
									var envato = "{{ route('social.login', 'envato') }}";
								</script>
								@endsection
		@section('scripts')

		<!-- Captcha Js-->
		<script src="https://www.google.com/recaptcha/api.js" async defer></script>
		
		<script type="text/javascript">
            "use strict";
			
			(function($){
				$(".captchabtn").on('click', function(e){
					e.preventDefault();
					$.ajax({
						type:'GET',
						url:'{{route('captcha.reload')}}',
						success: function(res){
							$(".captcha span").html(res.captcha);
						}
					});
				});
				
			})(jQuery);
		</script>
		@endsection